/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs;

import BryceMath.Calculations.Geometry;
import BryceMath.DoubleMath.Vector;
import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.BitSet;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj_Container;
import Game_Engine.Engine.Objs.Room;
import Game_Engine.Engine.Objs.actionLogging.obj_cursor;
import Game_Engine.Engine.engine.Game_input;
import Game_Engine.Engine.text.TextManager;
import Game_Engine.GUI.Components.small.boxes.gui_focusBox;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import util.SerialB;
import util.interfaces.Function;

public abstract class Obj
implements Comparable<Obj>,
SerialB {
    private double y;
    private double x;
    public double x_start;
    public double y_start;
    private int w = -1;
    private int h = -1;
    private boolean alive = true;
    private boolean end_step = false;
    private Obj_Container part_dead = null;
    private int depth = 0;
    protected boolean initialized = false;
    protected Obj_Container myContainer;
    protected BufferedImage sprite;
    protected double sprite_angle;
    protected int orgin_x = 0;
    protected int orgin_y = 0;
    private int alpha_collision_threshold = 0;
    private boolean visible = true;
    protected boolean collidable = true;
    protected int h_scale = 1;
    protected int v_scale = 1;
    public boolean mouseInRegion = false;
    public boolean highlighted = false;
    private boolean enabled = true;
    public static boolean default_TEX = true;
    private boolean TEX = default_TEX;
    private boolean updated = false;
    final int DRAW_TOLERANCE = 5;
    final int DRAW_T2 = 10;

    public Obj(double x_in, double y_in) {
        this.iVars(x_in, y_in);
    }

    public Obj() {
        this.iVars(0.0, 0.0);
    }

    private void iVars(double x_in, double y_in) {
        this.setX(x_in);
        this.setY(y_in);
        this.x_start = this.getX();
        this.y_start = this.getY();
        this.redraw();
    }

    protected void initialize() {
    }

    protected abstract void update();

    public void endStep() {
    }

    public void keyP(int key) {
    }

    public void forceKeyP(int key) {
    }

    public void keyR(int key) {
    }

    public void mouseP(int mx, int my) {
    }

    public void mouseR(int mx, int my) {
    }

    public void mouseM(int mx, int my) {
    }

    public void mouseD(int mx, int my) {
    }

    protected boolean mouse_left() {
        return Game_input.mouse_button == 1;
    }

    protected boolean mouse_center() {
        return Game_input.mouse_button == 2;
    }

    protected boolean mouse_right() {
        return Game_input.mouse_button == 3;
    }

    public void global_mouseP() {
    }

    public void global_mouseR() {
    }

    public void global_mouseM(int mx, int my) {
    }

    public void global_mouseD(int mx, int my) {
    }

    public void global_mouseScroll(int amount) {
    }

    protected void die() {
        this.alive = false;
        this.redraw();
    }

    public void kill(Obj_Container container) {
        this.part_dead = container;
    }

    protected boolean dead() {
        return !this.alive;
    }

    public boolean dead(Obj_Container container) {
        return this.dead() || this.part_dead == container;
    }

    public void ressurect() {
        this.alive = true;
        this.part_dead = null;
    }

    public void kill() {
        this.die();
    }

    public void revert() {
        this.setX(this.x_start);
        this.setY(this.y_start);
    }

    boolean getCeaseIteration() {
        if (this.end_step) {
            this.end_step = false;
            return true;
        }
        return false;
    }

    protected void breakIteration() {
        this.end_step = true;
    }

    @Override
    public int compareTo(Obj o) {
        if (this.depth > o.getDepth()) {
            return -1;
        }
        if (this.depth < o.getDepth()) {
            return 1;
        }
        return 0;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getW() {
        if (this.sprite == null || this.w != -1) {
            return this.w;
        }
        return this.sprite.getWidth() * this.h_scale;
    }

    public int getH() {
        if (this.sprite == null || this.h != -1) {
            return this.h;
        }
        return this.sprite.getHeight() * this.v_scale;
    }

    public void setH(int h_in) {
        if (this.h == h_in) {
            return;
        }
        this.redraw();
        this.h = h_in;
        this.redraw();
    }

    public void setW(int w_in) {
        if (this.w == w_in) {
            return;
        }
        this.redraw();
        this.w = w_in;
        this.redraw();
    }

    public void setDepth(int depth_new) {
        if (!(this instanceof obj_cursor)) {
            depth_new = Math.max(-2147483646, depth_new);
        }
        this.depth = depth_new;
    }

    public void setCollidable(boolean flag) {
        this.collidable = flag;
    }

    public void setVisible(boolean flag) {
        if (this.visible != flag) {
            this.redraw();
        }
        this.visible = flag;
    }

    public void setImage(BufferedImage image) {
        if (this.sprite != image) {
            this.redraw();
        }
        this.sprite = image;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isCollidable() {
        return this.collidable;
    }

    public Room getRoom() {
        Obj_Container result = this.myContainer;
        while (!(result instanceof Room)) {
            result = result.getContainer();
        }
        return (Room)result;
    }

    public void setContainer(Obj_Container c) {
        this.myContainer = c;
    }

    public Obj_Container getContainer() {
        return this.myContainer;
    }

    protected void room_restart() {
        this.end_step = true;
        this.getRoom().restart();
    }

    protected void room_goto(String name) {
        this.end_step = true;
        this.getRoom().goto_room(name);
    }

    protected void room_goto(Room r) {
        this.end_step = true;
        this.getRoom().goto_room(r);
    }

    public void draw(ImageB i, AffineTransform AT, CountDownLatch latch) {
        this.draw(i, AT);
        latch.countDown();
    }

    public void draw(ImageB i, AffineTransform AT) {
        if (!this.visible) {
            return;
        }
        Graphics2D g = i.getGraphics();
        this.drawImage(g, AT, this.getX(), this.getY(), this.sprite, this.sprite_angle);
    }

    public void drawImage(Graphics2D g, AffineTransform AT, double x, double y, BufferedImage image, double pivotX, double pivotY, double angle) {
        AffineTransform newTransform = new AffineTransform();
        newTransform.setToTranslation(x - pivotX + AT.getTranslateX(), y - pivotY + AT.getTranslateY());
        if (angle != 0.0) {
            newTransform.rotate(Math.toRadians(-angle), pivotX, pivotY);
        }
        g.drawImage(image, newTransform, null);
    }

    public void drawImage(Graphics2D g, AffineTransform AT, double x, double y, BufferedImage image, double angle) {
        this.drawImage(g, AT, x, y, image, this.orgin_x, this.orgin_y, angle);
    }

    public void drawImage(Graphics2D g, AffineTransform AT, double x, double y, BufferedImage image) {
        g.drawImage((Image)image, (int)(x + AT.getTranslateX()), (int)(y + AT.getTranslateY()), null);
    }

    public static void drawImage(Graphics2D g, AffineTransform AT, BufferedImage image) {
        g.drawImage(image, AT, null);
    }

    public void fillRect(Graphics2D g, double x, double y, int w, int h) {
        g.fillRect((int)x, (int)y, w, h);
    }

    public void fillRect(Graphics2D g, AffineTransform affineTransform, double x, double y, int w, int h) {
        g.fillRect((int)(x + affineTransform.getTranslateX()), (int)(y + affineTransform.getTranslateY()), w, h);
    }

    public void drawRect(Graphics2D g, AffineTransform affineTransform, double x, double y, int w, int h) {
        g.drawRect((int)(x + affineTransform.getTranslateX()), (int)(y + affineTransform.getTranslateY()), w, h);
    }

    public void fillOval(Graphics2D g, AffineTransform affineTransform, double x, double y, int w, int h) {
        g.fillOval((int)(x + affineTransform.getTranslateX()), (int)(y + affineTransform.getTranslateY()), w, h);
    }

    public void drawLine(Graphics2D g, AffineTransform AT, double x1, double y1, double x2, double y2) {
        if (AT == null) {
            g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            return;
        }
        g.drawLine((int)(x1 + AT.getTranslateX()), (int)(y1 + AT.getTranslateY()), (int)(x2 + AT.getTranslateX()), (int)(y2 + AT.getTranslateY()));
    }

    public void drawTextLeft(Graphics2D g, AffineTransform AT, double x, double y, String str) {
        TextManager.drawTextLeft(g, AT, x, y, str, this.TEX);
    }

    public void drawTextLeft(Graphics2D g, AffineTransform AT, double x, double y, String str, int size) {
        TextManager.drawTextLeft(g, AT, x, y, str, size, this.TEX);
    }

    public void drawTextCenter(Graphics2D g, AffineTransform AT, double x, double y, String str) {
        TextManager.drawTextCenter(g, AT, x, y, str, this.TEX);
    }

    public int drawTextCenter(Graphics2D g, AffineTransform AT, double x, double y, String str, int size) {
        return TextManager.drawTextCenter(g, AT, x, y, str, size, this.TEX);
    }

    public void drawTextRight(Graphics2D g, AffineTransform AT, double x, double y, String str) {
        TextManager.drawTextRight(g, AT, x, y, str, this.TEX);
    }

    public void drawTextRight(Graphics2D g, AffineTransform AT, double x, double y, String str, int size) {
        TextManager.drawTextRight(g, AT, x, y, str, size, this.TEX);
    }

    public boolean mouseCollision(int mouseX, int mouseY) {
        if (!this.visible || !this.collidable) {
            return false;
        }
        mouseX = (int)((double)mouseX - (this.getX() - (double)this.orgin_x));
        mouseY = (int)((double)mouseY - (this.getY() - (double)this.orgin_y));
        if (this.sprite == null) {
            if (Geometry.rectangle2(mouseX, mouseY, 0.0, 0.0, this.getW(), this.getH())) {
                this.mouseInRegion = true;
                return true;
            }
            return false;
        }
        return this.sprite_collision(mouseX, mouseY);
    }

    protected boolean sprite_collision(int mouseX, int mouseY) {
        int w = this.getW();
        int h = this.getH();
        if (mouseX >= 0 && mouseY >= 0 && mouseX < w && mouseY < h && this.sprite.getRGB(mouseX %= (w = this.sprite.getWidth()), mouseY %= (h = this.sprite.getHeight())) >>> 24 > this.alpha_collision_threshold) {
            this.mouseInRegion = true;
            return true;
        }
        return false;
    }

    public void center_orgin() {
        this.orgin_x = this.sprite.getWidth() / 2;
        this.orgin_y = this.sprite.getHeight() / 2;
    }

    public Obj instance_position(double x, double y, Class<?> class1) {
        return this.instance_position(x, y, class1, null);
    }

    public Obj instance_position(double x, double y, Class<?> class1, Function<Obj, Boolean> filter) {
        List<Obj> L = this.myContainer.getObjList();
        for (Obj o : L) {
            if (!class1.isAssignableFrom(o.getClass()) || o == this || !o.collidable || filter != null && !filter.eval(o).booleanValue() || !o.pointCollision((int)x, (int)y)) continue;
            return o;
        }
        return null;
    }

    public Obj instance_place(double x, double y, Class<?> class1) {
        return this.instance_place(x, y, class1, null);
    }

    public Obj instance_place(double x, double y, Class<?> class1, Function<Obj, Boolean> filter) {
        List<Obj> L = this.myContainer.getObjList();
        for (Obj o : L) {
            if (!class1.isAssignableFrom(o.getClass()) || o == this || !o.collidable || filter != null && !filter.eval(o).booleanValue() || !this.collision(x, y, o)) continue;
            return o;
        }
        return null;
    }

    public boolean collision(double x, double y, Obj o) {
        return o.getX() - (double)o.orgin_x < x - (double)this.orgin_x + (double)this.getW() && o.getX() - (double)o.orgin_x + (double)o.getW() > x - (double)this.orgin_x && o.getY() - (double)o.orgin_y < y - (double)this.orgin_y + (double)this.getH() && o.getY() - (double)o.orgin_y + (double)o.getH() > y - (double)this.orgin_y;
    }

    public boolean pointCollision(int x, int y) {
        if (!this.visible || !this.collidable) {
            return false;
        }
        x = (int)((double)x - (this.getX() - (double)this.orgin_x));
        y = (int)((double)y - (this.getY() - (double)this.orgin_y));
        if (this.sprite == null) {
            return Geometry.rectangle2(x, y, 0.0, 0.0, this.getW(), this.getH());
        }
        return x >= 0 && y >= 0 && x < this.sprite.getWidth() && y < this.sprite.getHeight() && this.sprite.getRGB(x, y) >>> 24 > this.alpha_collision_threshold;
    }

    public boolean collision(Obj o) {
        return this.collision(this.getX(), this.getY(), o);
    }

    public void resetMouseFlags() {
        if (this.mouseInRegion || this.highlighted) {
            this.redraw();
        }
        this.mouseInRegion = false;
        this.highlighted = false;
    }

    public Vector getPositionVector() {
        return new Vector(this.getX(), this.getY());
    }

    public Vector getStartingPositionVector() {
        return new Vector(this.x_start, this.y_start);
    }

    public int getRoomW() {
        return this.myContainer.getW();
    }

    public int getRoomH() {
        return this.myContainer.getH();
    }

    public boolean getInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean flag) {
        this.initialized = flag;
    }

    public void enable() {
        if (!this.enabled) {
            this.redraw();
        }
        this.enabled = true;
    }

    public void disable() {
        if (this.enabled) {
            this.redraw();
        }
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean flag) {
        if (this.enabled != flag) {
            this.redraw();
        }
        this.enabled = flag;
    }

    public double getX2() {
        return this.getX() + (double)this.getW();
    }

    public double getY2() {
        return this.getY() + (double)this.getH();
    }

    @Override
    public void serializeTo(PrintStream stream) {
        stream.println(this.getClass());
        stream.println("You should implement serialization for this class.");
        stream.println();
        throw new Error("Obj Serialization has not yet been implemented for: " + this.getClass().toString());
    }

    @Override
    public String getSerialName() {
        return "Temporary Serial Name : " + this.getClass().toString();
    }

    public void enableTEX() {
        if (!this.TEX) {
            this.redraw();
            this.TEX = true;
        }
    }

    public void disableTEX() {
        if (this.TEX) {
            this.redraw();
            this.TEX = false;
        }
    }

    public boolean getTEX() {
        return this.TEX;
    }

    public void hide() {
        this.setVisible(false);
        this.disable();
    }

    public void show() {
        this.setVisible(true);
        this.enable();
    }

    public void redraw() {
        try {
            int x = this.getScreenX();
            int y = this.getScreenY();
            Rectangle rect = new Rectangle(x - 5 - this.orgin_x, y - 5 - this.orgin_y, this.getW() + 10, this.getH() + 10);
            this.addDrawingRegion(rect);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addDrawingRegion(Rectangle rect) {
        this.getRoom().addDrawingRegion(rect);
    }

    public int getScreenX() {
        if (this.getRoom() == this) {
            return (int)this.getX();
        }
        return (int)(this.getX() + (double)this.myContainer.getScreenX());
    }

    public int getScreenY() {
        if (this.getRoom() == this) {
            return (int)this.getY();
        }
        return (int)(this.getY() + (double)this.myContainer.getScreenY());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getCenterX() {
        return this.x - (double)this.orgin_x + (double)(this.w / 2);
    }

    public double getCenterY() {
        return this.y - (double)this.orgin_y + (double)(this.h / 2);
    }

    public void xAdd(double xinc) {
        if (xinc == 0.0) {
            return;
        }
        this.redraw();
        this.x += xinc;
        this.redraw();
    }

    public void yAdd(double yinc) {
        if (yinc == 0.0) {
            return;
        }
        this.redraw();
        this.y += yinc;
        this.redraw();
    }

    public void xSub(double xinc) {
        if (xinc == 0.0) {
            return;
        }
        this.redraw();
        this.x -= xinc;
        this.redraw();
    }

    public void ySub(double yinc) {
        if (yinc == 0.0) {
            return;
        }
        this.redraw();
        this.y -= yinc;
        this.redraw();
    }

    public void setX(double x_in) {
        if (x_in == this.getX()) {
            return;
        }
        this.redraw();
        this.x = x_in;
        this.redraw();
    }

    public void setY(double y_in) {
        if (y_in == this.getY()) {
            return;
        }
        this.redraw();
        this.y = y_in;
        this.redraw();
    }

    public void center_sprite_orgin() {
        int x = this.sprite.getWidth() / 2;
        int y = this.sprite.getHeight() / 2;
        if (this.orgin_x == x && this.orgin_y == y) {
            return;
        }
        this.redraw();
        this.orgin_x = x;
        this.orgin_y = y;
        this.redraw();
    }

    public void setSprite(BufferedImage image) {
        if (this.sprite == image) {
            return;
        }
        this.redraw();
        this.sprite = image;
        this.redraw();
    }

    public boolean offScreen() {
        boolean b4;
        int room_w = this.getContainer().getW();
        int room_h = this.getContainer().getH();
        int x = 0;
        int y = 0;
        int w = this.getW();
        int h = this.getH();
        boolean b1 = x < -w + this.orgin_x;
        boolean b2 = y < -h + this.orgin_y;
        boolean b3 = x > room_w + this.orgin_x;
        boolean bl = b4 = y > room_h + this.orgin_y;
        return b1 || b2 || b3 || b4;
    }

    public void setDepthAbove(Obj o) {
        this.setDepth(o.getDepth() - 1);
    }

    public void setDepthBelow(Obj o) {
        this.setDepth(o.getDepth() + 1);
    }

    public void setOrginX(int x) {
        if (x == this.orgin_x) {
            return;
        }
        this.redraw();
        this.orgin_x = x;
        this.redraw();
    }

    public void setOrginY(int y) {
        if (y == this.orgin_y) {
            return;
        }
        this.redraw();
        this.orgin_y = y;
        this.redraw();
    }

    public void setOrgin(int x, int y) {
        this.setOrginX(x);
        this.setOrginY(y);
    }

    public void ensureUpdate() {
        if (!this.updated) {
            this.updated = true;
            this.update();
        }
    }

    public void resetUpdateFlagForNextStep() {
        this.updated = false;
    }

    public void moveTo(Obj o) {
        this.setX(o.getX());
        this.setY(o.getY());
    }

    public void moveTo(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    protected void drawRadialArray(Graphics2D g, AffineTransform AT, BufferedImage[] array, BitSet bits) {
        this.drawRadialArray(g, AT, array, bits, this.getX(), this.getY(), this.getW(), this.getH());
    }

    protected void drawRadialArray(Graphics2D g, AffineTransform AT, BufferedImage[] array, BitSet bits, double x, double y, int w, int h) {
        if (array.length != 8) {
            throw new Error("Non 8 length arrays not supported.");
        }
        switch (bits.toInt()) {
            case 0: {
                break;
            }
            case 255: {
                this.drawTextCenter(g, AT, x + (double)(w / 2), y + (double)(h / 2), "O", 10);
                break;
            }
            case -1: {
                break;
            }
            default: {
                int i = 0;
                while (i < 8) {
                    this.directionDraw(g, AT, i, array, bits);
                    ++i;
                }
                break block0;
            }
        }
    }

    private void directionDraw(Graphics2D g, AffineTransform AT, int direction, BufferedImage[] array, BitSet bits) {
        if (bits.getBit(direction)) {
            Vector v_dir = Vector.v_dir(45 * direction).mult(16.0);
            BufferedImage spr = array[direction];
            this.drawImage(g, AT, this.getX() + (double)(this.getW() / 2) - (double)this.orgin_x - (double)(spr.getWidth() / 2) + v_dir.getX(), this.getY() + (double)(this.getH() / 2) - (double)this.orgin_y - (double)(spr.getHeight() / 2) + v_dir.getY(), spr);
        }
    }

    protected static void eraseSelections() {
        gui_focusBox.eraseSelections();
    }

    public void setCollisionAlphaThreshold(int val) {
        this.alpha_collision_threshold = val;
    }
}

